/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.modules.MenuHolder;
import me.shedaniel.rei.impl.client.gui.widget.ConfigButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.CraftableFilterButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryHighlighter;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.PaginatedEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.ScrolledEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintsContainerWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.common.util.RectangleUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ScreenOverlayImpl
extends ScreenOverlay {
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static EntryListWidget entryListWidget = null;
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReload = false;
    public boolean shouldReloadSearch = false;
    private Rectangle bounds;
    private class_1041 window;
    private Widget configButton;
    private final CurrentDraggingStack draggingStack = new CurrentDraggingStack();
    @Nullable
    public DefaultDisplayChoosePageWidget choosePageWidget;
    private final MenuHolder menuHolder = new MenuHolder();
    private final HintsContainerWidget hintsWidget = new HintsContainerWidget();

    public static EntryListWidget getEntryListWidget() {
        boolean widgetScrolled = ConfigObject.getInstance().isEntryListWidgetScrolled();
        if (entryListWidget != null) {
            if (widgetScrolled && entryListWidget instanceof ScrolledEntryListWidget) {
                return entryListWidget;
            }
            if (!widgetScrolled && entryListWidget instanceof PaginatedEntryListWidget) {
                return entryListWidget;
            }
        }
        entryListWidget = widgetScrolled ? new ScrolledEntryListWidget() : new PaginatedEntryListWidget();
        ScreenOverlayImpl overlay = ScreenOverlayImpl.getInstance();
        Rectangle overlayBounds = overlay.bounds;
        entryListWidget.updateArea(Objects.requireNonNullElse(overlayBounds, new Rectangle()), REIRuntimeImpl.getSearchField() == null ? "" : REIRuntimeImpl.getSearchField().getText());
        entryListWidget.updateEntriesPosition();
        return entryListWidget;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    public static ScreenOverlayImpl getInstance() {
        return (ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().orElseThrow();
    }

    public void tick() {
        if (REIRuntimeImpl.getSearchField() != null) {
            REIRuntimeImpl.getSearchField().tick();
            if (class_310.method_1551().field_1724 != null && !PluginManager.areAnyReloading() && class_310.method_1551().field_1724.field_6012 % 5 == 0) {
                CraftableFilter.INSTANCE.tick();
            }
        }
    }

    @Override
    public void queueReloadOverlay() {
        this.shouldReload = true;
    }

    @Override
    public void queueReloadSearch() {
        this.shouldReloadSearch = true;
    }

    @Override
    public DraggingContext<?> getDraggingContext() {
        return this.draggingStack;
    }

    protected boolean hasSpace() {
        return !this.bounds.isEmpty();
    }

    public void init() {
        this.draggingStack.set(DraggableComponentProvider.from(ScreenRegistry.getInstance()::getDraggableComponentProviders), DraggableComponentVisitor.from(ScreenRegistry.getInstance()::getDraggableComponentVisitors));
        this.shouldReload = false;
        this.shouldReloadSearch = false;
        this.method_25396().clear();
        this.window = class_310.method_1551().method_22683();
        this.bounds = ScreenOverlayImpl.calculateOverlayBounds();
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            ScreenOverlayImpl.favoritesListWidget.favoritePanel.resetRows();
            this.widgets.add(favoritesListWidget);
        }
        OverlaySearchField searchField = REIRuntimeImpl.getSearchField();
        searchField.getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add(searchField);
        EntryListWidget entryListWidget = ScreenOverlayImpl.getEntryListWidget();
        entryListWidget.updateArea(this.bounds, searchField.getText());
        this.widgets.add(entryListWidget);
        searchField.setResponder(s -> entryListWidget.updateSearch((String)s, false));
        entryListWidget.init(this);
        this.configButton = ConfigButtonWidget.create(this);
        this.widgets.add(this.configButton);
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            this.widgets.add(CraftableFilterButtonWidget.create(this));
        }
        this.widgets.add(this.draggingStack);
        this.widgets.add(InternalWidgets.wrapLateRenderable(this.hintsWidget));
        this.hintsWidget.init();
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1;
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            widthRemoved += 22;
        }
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            widthRemoved += 22;
        }
        SearchFieldLocation searchFieldLocation = REIRuntime.getInstance().getContextualSearchFieldLocation();
        return switch (searchFieldLocation) {
            default -> throw new IncompatibleClassChangeError();
            case SearchFieldLocation.TOP_SIDE -> this.getTopSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.BOTTOM_SIDE -> this.getBottomSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.CENTER -> this.getCenterSearchFieldArea(widthRemoved);
        };
    }

    private Rectangle getTopSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getBottomSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, this.window.method_4502() - 22, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getCenterSearchFieldArea(int widthRemoved) {
        Rectangle screenBounds = ScreenRegistry.getInstance().getScreenBounds(this.minecraft.field_1755);
        return new Rectangle(screenBounds.x, this.window.method_4502() - 22, screenBounds.width - widthRemoved, 18);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.shouldReload || !ScreenOverlayImpl.calculateOverlayBounds().equals((Object)this.bounds)) {
            this.init();
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        } else {
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(this.minecraft.field_1755)) {
                if (decider == null || !decider.shouldRecalculateArea(ConfigObject.getInstance().getDisplayPanelLocation(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (this.shouldReloadSearch || ConfigManager.getInstance().isCraftableOnlyEnabled() && CraftableFilter.INSTANCE.wasDirty()) {
            this.shouldReloadSearch = false;
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isHighlighting) {
            EntryHighlighter.render(matrices);
        }
        if (!this.hasSpace()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderWidgets(matrices, mouseX, mouseY, delta);
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            class_437 screen = class_310.method_1551().field_1755;
            ClickArea.ClickAreaContext<class_437> context = this.createClickAreaContext(mouseX, mouseY, screen);
            List<class_2561> clickAreaTooltips = ScreenRegistry.getInstance().getClickAreaTooltips(screen.getClass(), context);
            if (clickAreaTooltips != null && !clickAreaTooltips.isEmpty()) {
                Tooltip.create(clickAreaTooltips).queue();
            }
        }
    }

    private ClickArea.ClickAreaContext<class_437> createClickAreaContext(final double mouseX, final double mouseY, final class_437 screen) {
        return new ClickArea.ClickAreaContext<class_437>(){

            @Override
            public class_437 getScreen() {
                return screen;
            }

            @Override
            public Point getMousePosition() {
                return new Point(mouseX, mouseY);
            }
        };
    }

    private static Rectangle calculateOverlayBounds() {
        Rectangle bounds = ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation(), class_310.method_1551().field_1755);
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundariesPercentage()));
        if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.RIGHT) {
            bounds.x += widthReduction;
        }
        bounds.width -= widthReduction;
        int maxWidth = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getHorizontalEntriesBoundariesColumns() + (double)EntryListWidget.entrySize() * 0.75);
        if (bounds.width > maxWidth) {
            if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.RIGHT) {
                bounds.x += bounds.width - maxWidth;
            }
            bounds.width = maxWidth;
        }
        return ScreenOverlayImpl.avoidButtons(bounds);
    }

    private static Rectangle avoidButtons(Rectangle bounds) {
        int buttonsHeight = 2;
        if (REIRuntime.getInstance().getContextualSearchFieldLocation() == SearchFieldLocation.TOP_SIDE) {
            buttonsHeight += 24;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            buttonsHeight += 22;
        }
        Rectangle area = REIRuntime.getInstance().calculateEntryListArea(bounds).clone();
        area.height = buttonsHeight;
        return RectangleUtils.excludeZones(bounds, ScreenRegistry.getInstance().exclusionZones().getExclusionZones(class_310.method_1551().field_1755).stream().filter(zone -> zone.intersects(area)));
    }

    public void lateRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (REIRuntime.getInstance().isOverlayVisible() && this.hasSpace()) {
            for (Widget widget : this.widgets) {
                if (widget instanceof LateRenderable && widget != this.menuHolder.widget()) {
                    widget.method_25394(matrices, mouseX, mouseY, delta);
                    continue;
                }
                if (!(widget instanceof OverlaySearchField)) continue;
                OverlaySearchField field = (OverlaySearchField)widget;
                field.laterRender(matrices, mouseX, mouseY, delta);
            }
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 500.0);
            this.menuHolder.lateRender(matrices, mouseX, mouseY, delta);
            matrices.method_22909();
            if (this.choosePageWidget != null) {
                this.method_25304(500);
                this.method_25296(matrices, 0, 0, this.window.method_4486(), this.window.method_4502(), -1072689136, -804253680);
                this.method_25304(0);
                this.choosePageWidget.method_25394(matrices, mouseX, mouseY, delta);
            }
        }
        if (this.choosePageWidget == null) {
            TOOLTIPS.stream().filter(Objects::nonNull).reduce((tooltip, tooltip2) -> tooltip2).ifPresent(tooltip -> this.renderTooltip(matrices, (Tooltip)tooltip));
        }
        TOOLTIPS.clear();
        if (REIRuntime.getInstance().isOverlayVisible()) {
            this.menuHolder.afterRender();
        }
    }

    public void renderTooltip(class_4587 matrices, Tooltip tooltip) {
        this.renderTooltipInner(this.minecraft.field_1755, matrices, tooltip, tooltip.getX(), tooltip.getY());
    }

    protected abstract void renderTooltipInner(class_437 var1, class_4587 var2, Tooltip var3, int var4, int var5);

    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null) {
            TOOLTIPS.add(tooltip);
        }
    }

    public void clearTooltips() {
        TOOLTIPS.clear();
    }

    public void renderWidgets(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return;
        }
        for (Widget widget : this.widgets) {
            if (widget instanceof LateRenderable) continue;
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (this.menuHolder.mouseScrolled(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.hintsWidget.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY) && ScreenOverlayImpl.getEntryListWidget().method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ScreenOverlayImpl.getEntryListWidget() || favoritesListWidget != null && widget == favoritesListWidget || widget == this.menuHolder.widget() || widget == this.hintsWidget || !widget.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible()) {
            if (keyCode == 256 && this.choosePageWidget != null) {
                this.choosePageWidget = null;
                return true;
            }
            if (this.choosePageWidget != null) {
                return this.choosePageWidget.method_25404(keyCode, scanCode, modifiers);
            }
            if (REIRuntimeImpl.getSearchField().method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            for (class_364 class_3642 : this.widgets) {
                if (class_3642 == REIRuntimeImpl.getSearchField() || !class_3642.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return true;
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(class_310.method_1551().field_1755, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.method_25395((class_364)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = System.currentTimeMillis();
            REIRuntimeImpl.getSearchField().keybindFocusKey = keyCode;
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible() && this.choosePageWidget == null) {
            if (REIRuntimeImpl.getSearchField().method_16803(keyCode, scanCode, modifiers)) {
                return true;
            }
            for (class_364 class_3642 : this.widgets) {
                if (class_3642 == REIRuntimeImpl.getSearchField() || class_3642 != this.method_25399() || !class_3642.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean method_25400(char character, int modifiers) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.method_25400(character, modifiers);
        }
        if (REIRuntimeImpl.getSearchField().method_25400(character, modifiers)) {
            return true;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == REIRuntimeImpl.getSearchField() || !class_3642.method_25400(character, modifiers)) continue;
            return true;
        }
        return false;
    }

    public List<Widget> method_25396() {
        return this.widgets;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean visible = REIRuntime.getInstance().isOverlayVisible();
        if (this.choosePageWidget != null) {
            if (this.choosePageWidget.containsMouse(mouseX, mouseY)) {
                return this.choosePageWidget.method_25402(mouseX, mouseY, button);
            }
            this.choosePageWidget = null;
            this.init();
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (visible && this.configButton.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.configButton);
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesMouse(button)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return REIRuntime.getInstance().isOverlayVisible();
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(class_310.method_1551().field_1755, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (visible && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(button)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (visible) {
            Widget menuWidget = this.menuHolder.widget();
            if (menuWidget != null && menuWidget.method_25402(mouseX, mouseY, button)) {
                this.method_25395((class_364)menuWidget);
                if (button == 0) {
                    this.method_25398(true);
                }
                REIRuntimeImpl.getSearchField().setFocused(false);
                return true;
            }
            if (this.hintsWidget.method_25402(mouseX, mouseY, button)) {
                this.method_25395((class_364)this.hintsWidget);
                if (button == 0) {
                    this.method_25398(true);
                }
                REIRuntimeImpl.getSearchField().setFocused(false);
                return true;
            }
        }
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            class_437 screen = class_310.method_1551().field_1755;
            ClickArea.ClickAreaContext<class_437> clickAreaContext = this.createClickAreaContext(mouseX, mouseY, screen);
            if (ScreenRegistry.getInstance().executeClickArea(screen.getClass(), clickAreaContext)) {
                return true;
            }
        }
        if (!visible) {
            return false;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == this.configButton || class_3642 == this.menuHolder.widget() || class_3642 == this.hintsWidget || !class_3642.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(class_3642);
            if (button == 0) {
                this.method_25398(true);
            }
            if (!(class_3642 instanceof OverlaySearchField)) {
                REIRuntimeImpl.getSearchField().setFocused(false);
            }
            return true;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesMouse(button)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.method_25395((class_364)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = -1L;
            REIRuntimeImpl.getSearchField().keybindFocusKey = -1;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return this.method_25399() != null && this.method_25397() && button == 0 && this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public class_364 method_25399() {
        if (this.choosePageWidget != null) {
            return this.choosePageWidget;
        }
        return super.method_25399();
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    @Override
    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(class_310.method_1551().field_1755)) {
            class_1269 in = decider.isInZone(mouseX, mouseY);
            if (in == class_1269.field_5811) continue;
            return in == class_1269.field_5812;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }

    @Override
    public OverlayListWidget getEntryList() {
        return ScreenOverlayImpl.getEntryListWidget();
    }

    @Override
    public Optional<OverlayListWidget> getFavoritesList() {
        return Optional.ofNullable(ScreenOverlayImpl.getFavoritesListWidget());
    }

    public MenuAccess menuAccess() {
        return this.menuHolder;
    }

    public HintsContainerWidget getHintsContainer() {
        return this.hintsWidget;
    }
}

